# Pioneering the use of technologies in qualitative research – A research review of the use of digital interviews

Sara Thunberg & Linda Arnell

To cite this article: Sara Thunberg & Linda Arnell (2022) Pioneering the use of technologies in qualitative research – A research review of the use of digital interviews, International Journal of Social Research Methodology, 25:6, 757-768, DOI: 10.1080/13645579.2021.1935565

To link to this article: https://doi.org/10.1080/13645579.2021.1935565

# Pioneering the use of technologies in qualitative research – A research review of the use of digital interviews

Sara Thunberg $\textcircled{1}$ and Linda Arnell

School of Law, Psychology and Social Work, Örebro University Örebro Sweden

# ABSTRACT

Covid-19 has changed the way research can be conducted. The present literature review, based on 29 studies (2008–2020), investigates and compiles existing research to identify possibilities and limitations of using digital interviews within social work, sociology and adjacent disciplines. The results show that digital interviews can enhance long-distance participation, and that they may be cost-effective. However, technical difficulties can arise that adversely affect the quality of the interviews. Concerning sensitive topics (e.g., victimization, health issues, sexuality), more rich data can be reached with digital options than with in-person options, but it can be difficult to read visual cues, as the camera only captures the participants’ upper body. Based on these results, it is important to strike a balance between the positive and negative aspects associated with digital interviews, and to understand that digital interviews are something different than in-person interviews, with their own logic and rules.

# KEYWORDS

Audio/visual interviews; digital interviews; method; qualitative research; video conferencing

# Introduction

Due to Covid-19, the year 2020 saw large changes in how people live their lives and perform their jobs, including when conducting research. People had to learn to use digital options that only a year before were not considered equivalent to in-person options, and therefore were avoided. To some extent the pandemic resulted in a new digital revolution, with researchers having to adapt to the novel situation (Nind et al., 2021). Still, the use of technology in research is not new, and digital research methods have been evaluated and discussed since the 1990s (e.g., Sellen, 1995), with the number of studies increasing from around the 2000s and onwards. It was also during the 1990s that ‘netnography’, combining the internet and ethnography, was introduced as a new methodology (Kozinets, 2015). However, digital methods and netnography are not exactly the same things; netnography is a digital method, but not all digital methods are netnography. ‘Digital methods’ is a wider concept that apart from netnography includes, for example, online surveys, telephone interviews, chat/instant message interviews, e-mail interviews, and video conference interviews. This article focuses on digital interviews using computer software that allows for audio and visual communication, hereafter referred to as digital interviews or audio/visual digital interviews.

Alternatives to in-person interviews have been under discussion for a long time, but the quality of the alternatives has been questioned. In-person interviews have been seen as the ‘gold standard’ for qualitative interviews (Lofland & Lofland, 1995, as cited in McCoyd & Kerson, 2006), because they enable both verbal and non-verbal cues to be taken into account. Still, in-person interviews may not always be possible because of geographical distance, health issues or, as now with the Covid-19 pandemic, the necessity of social distancing. Telephone interviews have been an alternative, especially for people who live far away from the researcher. Their weakness is the lack of non-verbal cues such as body language, and this has resulted in telephone interviews being viewed as an alternative to, but not a replacement for, in-person interviews (e.g., Novick, 2008; Opdenakker, 2006). However, Novick (2008) argues that there is no evidence that data would be lost or less rich due to a lack of non-verbal cues; on the contrary it may lead to more disclosure and thereby to richer data. Similarly, during the 1990s, when the internet started to make its way into people’s homes, asynchronous and synchronous interviews through e-mail or chat forums were introduced and tested as alternatives. However, like with telephone interviews, there is a risk of non-verbal cues being missed, and to some extent the risk is even greater because you do not have the voice of the interviewee to guide you (cf. Opdenakker, 2006). Still, text interviews could offer a degree of anonymity that was not possible before and digital methods are making hard-to-reach groups possible to include as participants in research projects, for example, young people or groups needed to research sensitive topics (Fox et al., 2007; Shapka et al., 2016). With this in mind, the introduction of computer software that allows both audio and visual communication may reduce many of the negative aspects associated with telephone and online text interviews, as both verbal and non-verbal cues can be studied. The present review therefore investigates and compiles existing research with the aim of identifying possibilities and limitations of using digital interviews within social work, sociology and adjacent disciplines.

# Method

A systematic integrative research review was conducted to achieve the aim of the study. Integrative reviews involve the integration of different types of studies using experimental, non-experimental, empirical, theoretical, qualitative, and quantitative methods, which makes them to some extent exploratory (Booth et al., 2016; cf. Petticrew & Roberts, 2008).

# Procedure

A scoping search was conducted in early September 2020 in the databases Social Services Abstracts (ProQuest) and Sociological Abstracts (ProQuest) to identify possible search terms ahead of the actual literature search (cf. Kiteley & Stogdon, 2014). Both of the databases were chosen as they are commonly used for identifying research associated with social work, sociology and adjacent disciplines. This means that the present review focuses on a narrower range of disciplines (Petticrew & Roberts, 2008). From the scoping search it became clear that the search terms concerning the use of digital methods are quite broad, making it difficult to specifically pinpoint the use of digital methods in research, as opposed to, for example, their use for communicating with people through social media, or digital activism. Even so, we arrived at the following combination of search terms: (digital interviews OR digital methods OR digital storytelling OR zoom OR skype OR facetime) AND method AND (young people OR youth\* OR adolescent OR teen\* OR child\*). This search, which was based on our initial aim of investigating and compiling existing research using audio/visual digital interviews with children and young people, yielded only one study that was in line with the aim. Hence the search was too narrow to be able to say anything about the use of digital interviews with children and young people. Thus, the aim of the study, as well as the search, were widened (Forsberg & Wengström, 2012; Kiteley & Stogdon, 2014).

To identify possibilities and limitations of using digital interviews within social work, sociology and adjacent disciplines, the specific focus was changed to include all studies in the databases Social Services Abstracts and Sociological Abstracts that focused on digital interviews, not only those with a focus on children and young people. Also, some modifications were made regarding what was meant by digital interviews. Although the first search was not successful in relation to doing a research review, it gave insight into possible new search terms to widen the search. The search as a whole shows that the field of digital methods generally, and digital interviews specifically, is a wide one, and includes several academic fields, however studies on the use of digital interviews specifically focusing on children and young people are sparser in the two selected databases.

![](images/79467c1d282f4549b50854692fabebc9b1d3d1c61fb6289206293f83b7654691.jpg)  
Figure 1. Flow diagram of the selection process for the review based on the searches in the two databases.

The new search was conducted on the $2 6 ^ { \mathrm { t h } }$ of September and focused primarily on research within social work and sociology, but also adjacent disciplines, using the search terms: (digital interviews OR internet interviews OR video conference OR zoom OR skype OR facetime) AND method). The search was conducted with the option that search terms could be anywhere except full text (NOFT). The search in Sociological Abstracts gave 534 hits, of which 52 were included based on their titles, while the search in Social Services Abstracts gave 182 hits, of which 11 were included based on their titles. After the abstracts of these 63 studies had been read and duplicates removed, 34 full texts were read, resulting in 18 studies being included in the review (see Figure 1).

The reference lists of these 18 studies were read to identify further potential studies to be included, a method called pearl growth (Booth et al., 2016; Petticrew & Roberts, 2008). This yielded an additional 22 studies, which were identified based on title and abstract. After reading the full texts of these in relation to the inclusion and exclusion criteria, 11 were added to the review. Many of these were frequently referenced by the included studies. The review therefore includes 29 studies in total (articles, research notes, research reviews). The studies that were excluded after reading the full texts focused on such things as using digital methods as a tool for treatment, digital interviews using text, and other digital methods, for example, surveys or visual methods.

# Inclusion and exclusion criteria

The present review focuses on studies that use computer software that allows the use of audio and visual communication, as both audio and visual aspects can help identify forms of non-verbal communication such as body language. Still, although visual communication is possible, there are a number of reasons why it might not be used, such as technical difficulties or an unsuitable physical environment. For this reason, although the studies needed to have used this type of software, studies with audio-only interviews were also included. The latter studies, though similar to studies using telephone interviews, could illustrate what needs to be further developed in the methodology. All studies also needed to be peer-reviewed and able to be read in full text. Studies that only focused on text-based digital interviews (e.g., e-mail, chat forums, or instant messaging) were excluded, as we wanted to focus on similarities with in-person interviews despite the difference in medium. Studies written in Swedish, Norwegian, Danish, or English were included, as these are languages understood by the authors. Studies on online treatment were excluded (unless the method used for the evaluation was digital interviews that allowed for audio and visual communication). Lastly, studies about teaching, for example, teaching masters students how to use digital interviews, and studies focusing on online quantitative studies were excluded. Publication date was not used as a criterion for inclusion or exclusion, because old as well as new studies can contribute knowledge about, for example, how software and technical issues have changed over time.

# Analysis

The present integrative research review used an inductive thematic analysis to identify, organize and analyze the studies (Booth et al., 2016; Braun & Clarke, 2006). This means that the studies were read multiple times in full to identify common themes in relation to the aim of this review (Braun & Clarke, 2006), and thus to identify possibilities and limitations of conducting digital interviews within social work, sociology and adjacent disciplines. The first author read all the articles and summarized them in a table that includes each study’s aim, method, main results, country of origin of the author/-s, and type of publication (see Appendix 1), which can be understood as the first step of the analysis (Braun & Clarke, 2006). The first author then used the summary as a foundation for an initial coding, after which the second author read all the articles and the summary made by the first author and added her perspective on the initial coding and interpretations. The authors then together made an in-depth thematic analysis, going back and forth between the articles and the analysis that was produced (Braun & Clarke, 2006). This meant looking beyond the individual studies and instead viewing them as evidence of something bigger (Booth et al., 2016). In this stage the analysis shifted to identifying similarities and differences between the studies to identify common themes, but also to identifying studies that did not ‘fit into’ the themes, as they might include information that has been overlooked in other studies. The authors had open discussions regarding the coding process, and how the results could be interpreted, with both authors’ opinions being given equal weight.

The coding of the studies was based on the possibilities and limitations raised about digital interviews, and the results from each study were coded based on their primary argumentation. The codes were then combined into the following four themes: (1) Long distance participation and costeffectiveness, (2) Technical difficulties, (3) Quality of the interviews, and (4) Ethical considerations, security, and sensitive topics. The themes are presented below. Each section starts with a brief presentation of the results and ends with some reflections or comparisons.

# Results

In this section, the results from the thematization of the articles included in the integrative review are presented. Overall, the review includes 29 studies published between 2008 and 2020, all of which are in English and use a qualitative methodology. Although the studies come from many parts of the world, there is a cluster around the USA $( \mathsf { n } = 1 0 )$ ) and United Kingdom $( \mathbf { n } = 9 )$ ), followed by Canada $\left( \mathbf { n } = 3 \right)$ ), Australia $\left( \mathbf { n } = 2 \right)$ ), Italy $( \mathbf { n } = 2 )$ ), Germany $( \mathbf { n } = 1 )$ ), New Zealand $( \mathbf { n } = 1 )$ ), and Saudi Arabia $( \mathbf { n } = 1 )$ ). Of these, 24 are categorized as articles, four as research notes, and one as a research review. The studies are categorized based on how the journals or the authors of the studies have categorized them. More information about the specific studies can be found in Appendix 1. As mentioned above, the results are grouped under the four themes that emerged from the analysis.

# Long distance participation and cost-effectiveness

An advantage that almost all studies raise is the possibility to include people that live further away from the researcher, cutting travel costs for the researcher or participants. This also means that groups of participants that previously could not be included in research due to long geographical distance can now be included (Deakin & Wakefield, 2013), and the method was in fact chosen by participants living further away (e.g., Hanna, 2012; Lo Iacono et al., 2016; Jenner & Myers, 2019). Gratton and O’Donnell (2011) have calculated the time and money they saved by arranging digital focus groups through video conferencing with people living in remote areas of northern Ontario, and conclude that by cutting traveling days, digital interviewing saved them significant amounts of time and money. Travel costs would also have been significant for the participants, as they would have had to travel to interview sites from even more remote areas. All these costs were reduced by using digital interviewing. Similarly, the participants might not need to take time off from work or studies, or be away from their families. However, the authors’ calculation does not include extra costs for the software or technical support, which Gray et al. (2020) argue can be a disadvantage with digital interviews. Namey et al. (2019) also argue that digital and in-person interviews carry equivalent costs, but for different things. Text interviews are more cost-effective in that respect. There is probably still money to be saved, but how much might depend on the distance that needs to be traveled, as longer distances involve greater costs. Similarly, there are differences in institutional conditions between countries and universities regarding the types of video conferencing software that are available and the costs incurred by individual research projects when using them, which also influences how much can be saved by using audio/visual digital interviews.

# Technical difficulties

The technical difficulties described differ between the studies, as do the types of programs used. Although different programs are used (e.g., Skype, Zoom, Access Grid), they seem to exhibit similar problems. It is important to bear in mind that some of the studies are older than others, meaning that some problems may have been solved as the technology has matured. In only one study do the authors express that they had no technical difficulties during the digital interviews using Skype, but due to recruitment problems they still conclude that at the time when the study was conducted, Skype interviews could not be considered a replacement for, or complement to, telephone interviews (Weinmann et al., 2012). The rest of the studies all report either technical problems or fear of technical problems related to the risk of loss of connection or lags (e.g., Jenner & Myers, 2019; Mirick & Wladkowski, 2019; Sipes et al., 2019; Sullivan, 2012; Weller, 2017). Although there is a span of seven years between the first and last publications in the examples above, the technical problems persist. To be able to use audio/visual digital interviews, high bandwidth is needed (Alkhateeb, 2018; Archibald et al., 2019; Sedgwick & Spiers, 2009). This means that even though digital interviews enable people to participate over long distances, the internet infrastructure needs to be robust enough to sustain a high-bandwidth connection. Otherwise it will not work (Glassmeyer & Dibbs, 2012), especially if the camera is to be used (cf. Deakin & Wakefield, 2013). Adequate internet is not available in every country or local community, meaning that audio/visual digital interviews might be difficult to conduct, depending on the bandwidth and quality of the internet connection, but as the technology develops this could become less of a problem.

Another aspect concerned how much experience the researchers and participants had with the program used for the interview. In some cases, participants were unfamiliar with the program, requiring the researcher to instruct the participants in using the system, which can take time from the interview (e.g., Alkhateeb, 2018; Archibald et al., 2019; N. Fielding, 2010; Lo Iacono et al., 2016). Still, Zoom is at least described as user-friendly, and according to Archibald et al. (2019) as many as 66 percent of the participants preferred Zoom over in-person interviews, while many described it as the second-best option, after in-person interviews, even though 88 percent reported experiencing some sort of technical difficulty using the program. Other difficulties that were expressed concerning digital interviews are sound delays (Adams-Hutcheson & Longhurst, 2017; Fielding & Fielding, 2012), not being able to see all the participants at the same time during focus groups (Gratton & O’Donnell, 2011), and lack of technical resources (Rowe et al., 2014; Sedgwick & Spiers, 2009).

Although the extent of these technical difficulties varied between the studies, they show the importance of testing the technology together with participants before interviews. Both Gray et al. (2020) and Seitz (2015) stress the importance of this, and the latter argues that trying out the technology together with a participant can start building rapport, or in other words, can help build a relationship between the researcher and the participant, making the interview situation more relaxed. Gray et al. (2020) even offer a 10-point list of what to think about when conducting audio/ visual digital interviews using Zoom, where all the points relate to technical aspects in one way or another. Examples include providing technical information and a direct link to the meeting, having a back-up plan, using a stable internet connection (not a wireless connection), and considering the storage needs for the recordings. Taken together, the reported technical difficulties show that digital interviews using video conferencing software might not be easy to carry out, but with adequate planning they can be a valuable tool for data collection.

# Quality of the interviews

Several studies compare the quality of digital interviews using video conferencing software with that of primarily in-person options, but also text interviews and audio-only interviews (with the camera turned off). In the studies, quality concerns how rich the data is compared to that gathered in inperson interviews, and how to achieve richness using audio/visual software. In this regard, one criticism of digital interviews is their lack of visual cues (Edwards & Holland, 2020). This should not be an issue with audio/visual digital interviews (Gratton & O’Donnell, 2011). However, studies reveal that the camera might be turned off or not function properly due to technical difficulties (e.g., Deakin & Wakefield, 2013; Sedgwick & Spiers, 2009). Similarly, in most cases the camera will only be able to capture the head and some of the upper body, meaning that visual cues in the form of body language can still be missed (Lo Iacono et al., 2016). The physical distance between the researcher and the participant can also affect the interview and poses a risk of distress, as the researcher may not be able to read certain cues as signs of distress (Sipes et al., 2019; cf. Seitz, 2015). This can be a reason why some people do not want to participate in digital interviews using video conferencing software (Cipolletta et al., 2017; Weinmann et al., 2012), and why they express that they would feel uncomfortable (Adams-Hutcheson & Longhurst, 2017). Other aspects include a higher tendency to drop out at the last minute (Deakin & Wakefield, 2013), and how well the participants liked the speaker/researcher (Ferran & Watts, 2008). Overall, this means that the online option might affect what kind of information participants can take in and understand, what information the researcher will be able to capture, and the richness of the data.

Despite these quality issues, other studies and researchers argue that digital interviews, using video conferencing software, are just as satisfactory and effective as in-person options for data collection, because the camera adds a dimension lacking in telephone interviews (e.g., Sedgwick & Spiers, 2009; Hanna, 2012; Mirick & Wladkowski, 2019; Namey et al., 2019; cf. Niero, 2014). Some researchers even state that they are better, as the participants feel more relaxed and at ease when they can participate in a more flexible setting and do not have to meet a stranger for an interview, and this can make them feel more comfortable disclosing their experiences (Alkhateeb, 2018; Sipes et al., 2019; Weller, 2017). Abrams, Wang, Song and Galindo-Gonzalez (2014) argue that their digital focus-group interviews produced more data than the in-person option, and were just as rich. The answers, although shorter, were more to the point (Woodyatt et al., 2016). Similarly, although body language might need to be exaggerated to be conveyed in video, at least it is visible and can be read, and the online setting can reduce the power imbalance between the researcher and the participant, as participants are more in control of their participation and can log off at any time (Fielding, 2010; Fielding & Fielding, 2012). Furthermore, Lo Iacono et al. (2016) and Jenner and Myers (2019) argue that rapport is as easy to build over the internet as it is in an offline setting, and that the online interviews do not suffer from over-disclosure. However, McCarrick et al. (2016) express that it took some time to establish a good relationship with those who participated online, but once they had settled in, there was no difference.

This theme shows that the studies do not all point in the same direction; some are more positive than others, and some also discuss both positive and negative aspects of the digital options. The differences that emerged are perhaps related more to the topic of the interview and which groups of participants that were interviewed. For example, one might not expect sensitive topics to be suitable for digital interviewing, but studies conducted on sensitive topics and with vulnerable groups of participants draw more positive conclusions about digital interviews than other studies. (This is discussed further in the next section.) This does not mean that the format has no limitations. It is important to bear in mind that although online options might offer the same or similar quality as in-person options, they are a different type of interview that requires different preparations to reduce the risk of adverse effects on quality. This relates to some extent to technical experience with the software used, as well as camera placement (and that it is turned on), but it also relates to the relationship between the researcher and the interviewee.

# Ethical considerations, security, and sensitive topics

As mentioned in the previous section, not all topics or groups of potential participants might be suitable for online interviews. Some studies even argue that interviews on sensitive topics should not be conducted over the internet, as the researcher needs to be able to read the visual and nonverbal cues that participants express, and because of the security risk associated with digital interviews (Hay-Gibson, 2009; Lo Iacono et al., 2016; Sedgwick & Spiers, 2009; Seitz, 2015). However, others express that the online setting is appropriate for interviewing people on sensitive topics such as health (Cipolletta et al., 2017; Gratton & O’Donnell, 2011; Rowe et al., 2014), parenthood (Gray et al., 2020), sexual identity (Sipes et al., 2019), and intimate partner violence (Woodyatt et al., 2016). When it comes to research on minorities or vulnerable groups such as victims of violence (Woodyatt et al., 2016), persons with a psychiatric diagnosis (Rowe et al. (2014), transgender people (Cipolletta et al., 2017), and indigenous communities (Gratton & O’Donnell, 2011), the studies show that an online setting is experienced positively. Weller (2017) also argues that the physical distance between the researcher and the participant during Skype interviews ‘can facilitate a greater (emotional) connection through participants’ increased sense of ease with the setting and mode’ (p. 623). McCarrick et al. (2016), however, state that building rapport took more time using Skype, and conclude that the rapport building needs to start before the interview begins, to reduce potential discomfort for the participant. Furthermore, the online setting offers an additional level of anonymity (if only audio is used) and the interview can be terminated at any time by just logging off (Adams-Hutcheson & Longhurst, 2017; Fielding & Fielding, 2012; Jenner & Myers, 2019; Sipes et al., 2019; Woodyatt et al., 2016). This means that, on the one hand, digital interviews might be a better choice for sensitive topics, as the participants are in more control over the interview and can end their participation at any time. They can of course do this in an in-person situation as well, but they might be more hesitant to do so, both out of a wish to please the researcher and because of the greater difficulty of leaving a physical interview situation. The physical distance that the digital option offers might make the participant less hesitant, as ending the interview is just a click away. Similarly, they can choose whether or not to have their camera on. Based on results regarding quality, video is preferred, to be able to read visual cues, but participants can still choose to turn it off to protect their privacy (Alkhateeb, 2018; Deakin & Wakefield, 2013). On the other hand, not knowing who is on the other side of the digital conversation might affect the authenticity of the data, as the identity of the participant cannot be fully established (Lo Iacono et al., 2016; Sullivan, 2012). This can raise ethical concerns regarding consent. For example, similar to other digital methods, how does the researcher know that the person who has consented to participate in an interview is the same one who is logged in to conduct it?

Another ethical concern relating to anonymity and the extra layer of anonymity that digital interviews might offer is digital security. Although a participant might want to use an alias, or turn off the camera, his or her IP address might be tracked. Most currently available software for digital interviews is offered by a third party that might be able to intercept the data transmission (HayGibson, 2009). Although the study that raised these concerns is a few years old, such concerns are still valid today. This means that from an ethical standpoint, the researcher needs to investigate what can be done to make sure that the participants cannot be tracked, and to inform the participants about any possible digital information that might be stored. This responsibility goes beyond what is necessary for in-person interviews. This does not however mean that the digital interviews are more problematic, but merely that they raise other concerns that need to be reflected upon and handled.

Obtaining consent can be a more complicated process with digital interviews, and in the studies included in the review, both written and/or oral consent have been used. As in other forms of research, it is important to consider all the steps thoroughly before the data collection begins. Gray et al. (2020), for example, suggest that in addition to the consent to participate in the interview, separate consent should be obtained for recording the interview. Also, before the interview, the information letter and the consent form should be discussed once more with the participant to enable potential questions to be raised and make sure that they are answered before the interview begins. This should be done to make sure that the participant understands the research process. If verbal consent is used, it should be recorded separately, not in the same recording as the interview (Gray et al., 2020). Similarly, Deakin and Wakefield (2013) suggest that if verbal consent is used, a written consent form should still be prepared and read verbatim to the participant before consent is given. This to make sure that all participants consent to the same thing and to minimize the risk of missing any points to which they are consenting. Both of these studies show that researchers need to think about how they obtain consent from the participants and provide reasons why that is the best option for the specific study.

Lastly, during the interviews it is important that both the participants and the researcher are in an environment where they will not be disturbed. For example, Jenner and Myers (2019) highlight the importance of having a private space during an interview, especially concerning sensitive topics, regardless of whether the interview is done via Skype or face-to face. Although this is something that should be obvious, several of the studies address different kind of disruptions. For example, Glassmeyer and Dibbs (2012) mention doing the interview in a shared office, with colleagues walking in on the interview and becoming a part of the video. Similarly, participants have been sitting in their homes and other family members have walked in, resulting in disruptions (AdamsHutcheson & Longhurst, 2017). This might not be a problem, but ethically it is important to make sure that the interview is conducted in a place that is quiet and where other people cannot just walk in, especially if sensitive subjects are being discussed. Otherwise, the confidentiality of the interview and what the participants talk about might be questioned.

# Discussion

The present review investigated and compiled existing research to identify possibilities and limitations of using digital interviews within social work, sociology and adjacent disciplines. Overall, there is somewhat of a consensus that audio/visual digital interviews can be a good strategy for collecting data when the participants live far away from the researcher and when researching sensitive topics or doing research on minorities or vulnerable groups, assuming that ethical issue are reflected upon and handled, and the internet infrastructure is robust enough. Knowing that digital interviewing is an option is important for the fields of social work, sociology and adjacent disciplines, especially at times or in situations where in-person interviews are difficult to carry out. However, whether the method is time- and cost-effective can be discussed. One reason for the different conclusions in the studies might relate to how far the researcher or the participants need to travel compared to the costs for the technology used. Still, it should not automatically be thought of as a cost-effective method, and other values such as sustainability (Hanna, 2012) or data quality might also be considered when choosing a method to collect data.

Concerning data quality, the studies show different results, with some arguing that in-person options are still to be preferred, and others that digital interviews are just as good and in some respects even better. Technical problems are mentioned, and although the software has improved over time and become more user-friendly, it is not uncommon to experience problems related to the technology, such as disconnections or lags, which is also confirmed in a review by Nind et al. (2021). The main criticism, however, concerns whether or not visual cues can be identified. Although more visual cues can probably be read in an in-person setting, as the camera usually only captures the head and upper body (Fielding & Fielding, 2012; Seitz, 2015), audio/visual interviews seem to be closest to the ‘gold standard’ (Lofland & Lofland, 1995, as cited in McCoyd & Kerson, 2006) of interviewing. However, audio/visual interviews also raise ethical concerns with regard to visual cues, especially if the researcher cannot determine if a participant is distressed by the interview (cf. Nind et al., 2021), but also regarding norms for audio and visual communication.

Digital interviews using software that allows for audio and visual communication can be understood as a new medium, for which the norms and rules of interaction have not yet been established, especially because such interviews can invite the other party into a private space (e.g., a home), meaning that a formal interview is conducted in an informal setting. This could also cause people to be more willing to disclose their experiences, as described in some studies (e.g., Jenner & Myers, 2019; Weller, 2017). The digital medium is still developing its norms, and needs to be understood as something different than in-person interviews. The quality of data, in terms of richness, as well as ethical issues can thus be related to the possibility for the interviewer and the interviewee to see and hear each other properly, as well as to establish their own norms and rules for the communication. It is therefore important to give special ethical consideration to each project, as the digital medium raises ethical concerns that might not be an issue in in-person interviews.

Overall, this review shows that previous studies are somewhat positive towards the use of audio/ visual digital interviewing as a method for collecting qualitative data, but there are risks of technical difficulties on both ends, and back-up plans may be needed (e.g., Gray et al., 2020). Still, looking at the data quality, there seems to be little or no difference between it and in-person interviews (e.g., Namey et al., 2019; Sedgwick & Spiers, 2009; Sullivan, 2012). As long as the technology works as planned, conducting interviews with audio/visual software seems to be a good option. These results are in line with methodological handbooks that focus on digital interviews. O’Connor and Madge (2017), for example, argue that so far there has been a limited focus on synchronous digital interviews in research, compared to asynchronous interviews. This is the case even though synchronous interviews would be more similar to in-person interviews, especially if audio and visual communication are used. Still, one reason for the limited amount of research so far might be that both the researcher and the participants need technical skills to use the software, making the medium potentially less attractive (O’Connor & Madge, 2017).

Furthermore, audio/visual digital interviews are also quite new, but are steadily increasing as the computer software develops. In relation to the Covid-19 pandemic, this development has also increased in speed, as more people are using such software and saying what works and what does not, which will further drive the development of digital methods (cf. Lee et al., 2017). The present review therefore contributes a compilation of the research on audio/visual digital interviewing from two databases related to social work, sociology, and adjacent disciplines to illustrate the use of the method. The use of digital interviews, or digital methods in general, also expands the methodological tool box for researchers, enabling them to combine several methods (cf. Fielding, 2018) to better answer research questions of a more complex nature.

In times and situations where the possibilities for in-person interaction are hampered or limited for different reasons, for example, geographical distance, health problems, housing or family situation, or a pandemic such as Covid-19, it is important to find new ways to conduct interviews and do qualitative research, and we argue that audio/visual digital interviews can be a good alternative for capturing people’s narratives and perspectives when other options are not possible or available (cf. Edwards & Holland, 2020). Also, when it comes to sensitive topics, vulnerable groups, or people who live remotely, research shows that digital methods can work well and that they are experienced positively, making it possible for people who otherwise may not be able to participate to contribute by telling their story, giving their perspective, and being a part of the knowledge production.

# Limitations and future research

Although the present review used a systematic approach when choosing which studies to include, it is clear that digital interviews go by many different names, and a limitation of the study is that we may have missed some central and significant concepts, and some studies may have been left out that should have been included. The review uses a relatively small sample of databases that are both related to the authors’ own disciplines and are ProQuest databases, which may have affected the number of studies found in the original searches. Another limitation relates to the initial aim of the review, namely, to investigate the use of digital interviews in research concerning children and young people. However, the fact that we needed to widen our aim, despite this method having been used for years, shows that more research is needed concerning the methodology in relation to children and young people.

Accordingly, more research is needed concerning the use of audio/visual digital interviews with children and young people. The lack of studies concerning this in relation to social work, sociology and adjacent disciplines may have to do with the fact that members of this group are often understood as particularly vulnerable due to their age. At the same time, the studies in this review show that vulnerable groups have positive experiences of the online setting. In the case of children and young people, it may also be important to consider that in many societies the younger population is understood to be more used to digital options, and thus better able to handle digital technology and solve problems that might arise during a digital interview. More research is also needed on digital interviews within social work and sociology about sensitive topics to examine whether they are as good as in-person interviews, or if the quality of the data collected is adversely affected.

# Acknowledgments

The authors would like to thank associate professor Björn Johansson, Örebro University, as well as the anonymous reviewers, for comments on previous drafts of this article.

# Disclosure of potential conflicts of interest

No potential conflict of interest was reported by the author(s).

# Notes on contributors

Sara Thunberg has a PhD and is a Senior lecturer in Social Work at the School of Law, Psychology and Social Work, Örebro University, Sweden. Her research interests focus on young victims of crime, need of support post-victimization, and children’s life-situation related to intimate partner violence.

Linda Arnell, has a PhD in social work and is a researcher at the School of Law, Psychology and Social Work, Örebro University, Sweden. Her research interests focus on children’s living conditions and social relations, with a special interest in gender, violence and emotions.

# ORCID

Sara Thunberg $\textcircled{1}$ http://orcid.org/0000-0002-1406-2064

# References

Abrams, K. M., Wang, Z., song, Y. J., & Galindo-Gonzalez, S. (2014). Data Richness Trade-Offs Between Face-toFace, Online Audiovisual, and Online Text-Only Focus Groups. Social Science Computer Review, 33(1), 80–96. https://doi.org/10.1177/0894439313519733   
Adams-Hutcheson, G., & Longhurst, R. (2017). ‘At least in person there would have been a cup of tea’: Interviewing via Skype. Area, 49(2), 148–155. https://doi.org/10.1111/area.12306   
Alkhateeb, M. (2018). Using Skype as a Qualitative Interview Medium within the Context of Saudi Arabia: A Research Note. Qualitative Report, 23(10), 2253–2260. https://doi.org/10.46743/2160-3715/2018.2805   
Archibald, M. M., Ambagtsheer, R. C., Casey, M. G., & Lawless, M. (2019). Using Zoom Videoconferencing for Qualitative Data Collection: Perceptions and Experiences of Researchers and Participants. International Journal of Qualitative Methods, 18, 1–8. https://doi.org/10.1177/1609406919874596   
Booth, A., Sutton, A., & Papaioannou, D. (2 eds.). (2016). Systematic Approaches to A Successful Literature Review. Sage Publications Ltd.   
Braun, V., & Clarke, V. (2006). Using thematic analysis in psychology. Qualitative Research in Psychology, 3(2), 77–101. https://doi.org/10.1191/1478088706qp063oa   
Cipolletta, S., Votadoro, R., & Faccio, E. (2017). Online support for transgender people: An analysis of forums and social networks. Health & Social Care in the Community, 25(5), 1542–1551. https://doi.org/10.1111/hsc.12448   
Deakin, H., & Wakefield, K. (2013). Skype interviewing: Reflections of two PhD researchers. Qualitative Research, 14 (5), 603–616. https://doi.org/10.1177/1468794113488126   
Edwards, R., & Holland, J. (2020). Reviewing challenges and the future for qualitative interviewing. International Journal of Social Research Methodology, 23(5), 581–592. https://doi.org/10.1080/13645579.2020.1766767   
Ferran, C., & Watts, S. (2008). Videoconferencing in the Field: A Heuristic Processing Model. Management Science, 54(9), 1565–1578. https://doi.org/10.1287/mnsc.1080.0879   
Fielding, N. (2010). Virtual Fieldwork Using Access Grid. Field Methods, 22(3), 195–216. https://doi.org/10.1177/ 1525822X10374277   
Fielding, N. G. (2018). Combining Digital and Physical Data. In U. Flick (Ed.), The SAGE Handbook of Qualitative Data Collection (pp. 584–598). SAGE Publications Ltd.   
Fielding, N. G., & Fielding, J. L. (2012). User satisfaction and user experiences with Access Grid as a medium for social science research: A research note. International Journal of Social Research Methodology, 15(5), 355–367. https://doi.org/10.1080/13645579.2011.597655   
Forsberg, C., & Wengström, Y. (2012). Att göra systematiska litteraturstudier - Värdering, analys och presentation av omvårdnadsforskning [Conducting systematic literature studies - Evaluation, analysis, and presentation of nursing research]. Natur & Kultur.   
Fox, F. E., Morris, M., & Rumsey, N. (2007). Doing Synchronous Online Focus Groups With Young People: Methodological Reflections. Qualitative Health Research, 17(4), 539–547. https://doi.org/10.1177/ 1049732306298754   
Glassmeyer, D. M., & Dibbs, R.-A. (2012). Researching from a Distance: Using Live Web Conferencing to Mediate Data Collection. International Journal of Qualitative Methods, 11(3), 292–302. https://doi.org/10.1177/ 160940691201100308   
Gratton, M.-F., & O’Donnell, S. (2011). Communication technologies for focus groups with remote communities: A case study of research with First Nations in Canada. Qualitative Research, 11(2), 159–175. https://doi.org/10. 1177/1468794110394068   
Gray, L., Wong, G., Rempel, G., & Cook, K. (2020). Expanding Qualitative Research Interviewing Strategies: Zoom Video Communications. The Qualitative Report, 25(5), 1292–1301. https://doi.org/10.46743/2160-3715/2020.4212   
Hanna, P. (2012). Using internet technologies (such as Skype) as a research medium: A research note. Qualitative Research, 12(2), 239–242. https://doi.org/10.1177/1468794111426607   
Hay-Gibson, N. (2009). Interviews via VoIP: Benefits and Disadvantages within a PhD study of SMEs. Library and Information Research, 33(105), 39–50. https://doi.org/10.29173/lirg111   
Jenner, B. M., & Myers, K. C. (2019). Intimacy, rapport, and exceptional disclosure: A comparison of in-person and mediated interview contexts. International Journal of Social Research Methodology, 22(2), 165–177. https://doi.org/ 10.1080/13645579.2018.1512694   
Kiteley, R., & Stogdon, C. (2014). Literature Reviews in Social Work. Sage Publications Ltd.   
Kozinets, R. (2015). Netnography. In R. Mansell & P. Hwa Ang (Eds.), The International Encyclopedia of Digital Communication and Society. Wiley Blackwell. https://doi.org/10.1002/9781118767771.wbiedcs067   
Lee, R. M., Fielding, N. G., & Blank, G. (2017). Online Research Methods in the Social Sciences: An Editorial Introduction. In N. G. Fielding, R. M. Lee, & G. Blank (Eds.), The SAGE Handbook of Online Research Methods (2 ed. ed., pp. 3–16). SAGE Publications Ltd.   
Lo Iacono, V., Symonds, P., & Brown, D. H. K. (2016). Skype as a Tool for Qualitative Research Interviews. Sociological Research Online, 21(2), 103–117. https://doi.org/10.5153/sro.3952   
McCarrick, J., Davis-McCabe, C., & Hirst-Winthrop, S. (2016). Men’s Experiences of the Criminal Justice System Following Female Perpetrated Intimate Partner Violence. Journal of Family Violence, 31(2), 203–213. https://doi. org/10.1007/s10896-015-9749-z   
McCoyd, J. L. M., & Kerson, T. S. (2006). Conducting Intensive Interviews Using Email: A Serendipitous Comparative Opportunity. Qualitative Social Work, 5(3), 389–406. https://doi.org/10.1177/1473325006067367   
Mirick, R. G., & Wladkowski, S. P. J. T. Q. R. (2019). Skype in Qualitative Interviews: Participant and Researcher Perspectives. The Qualitative Report, 24(12), 3061–3072. https://doi.org/10.46743/2160-3715/2019.3632   
Namey, E., Guest, G., O’Regan, A., Godwin, C. L., Taylor, J., & Martinez, A. (2019). How Does Mode of Qualitative Data Collection Affect Data and Cost? Findings from a Quasi-experimental Study. Field Methods, 32(1), 58–74. https://doi.org/10.1177/1525822X19886839   
Niero, M. (2014). The Invisible Interviewer: Old and New Methodological Issues in Online Research. Italian Sociological Review, 4(3), 315–340. https://doi.org/10.13136/isr.v4i3.88   
Nind, M., Coverdale, A., & Meckin, R. (2021). Changing Social Research Practices in the Context of Covid-19: Rapid Evidence Review.Project Report. NCRM. http://eprints.ncrm.ac.uk/4398/   
Novick, G. (2008). Is there a bias against telephone interviews in qualitative research? Research in Nursing & Health, 31(4), 391–398. https://doi.org/10.1002/nur.20259   
O’Connor, H., & Madge, C. (2017). Online Interviewing. In N. G. Fielding, R. M. Lee, & G. Blank (Eds.), The SAGE Handbook of Online Research Methods (2 ed. ed., pp. 416–434). SAGE Publications Ltd.   
Opdenakker, R. (2006). Advantages and Disadvantages of Four Interview Techniques in Qualitative Research [Electronic Journal]. Forum Qualitative Sozialforschung/Forum: Qualitative Social Research, 7 (4), 11. Art. https://doi.org/10.17169/fqs-7.4.175   
Petticrew, M., & Roberts, H. (2008). Systematic reviews in the social sciences: A practical guide. Wiley.   
Rowe, M., Rosenheck, R., Stern, E., & Bellamy, C. (2014). Video Conferencing Technology in Research on Schizophrenia: A Qualitative Study of Site Research Staff. Psychiatry, 77(1), 98–102. https://doi.org/10.1521/ psyc.2014.77.1.98   
Sedgwick, M., & Spiers, J. (2009). The Use of Videoconferencing as a Medium for the Qualitative Interview. International Journal of Qualitative Methods, 8(1), 1–11. https://doi.org/10.1177/160940690900800101   
Seitz, S. (2015). Pixilated partnerships, overcoming obstacles in qualitative interviews via Skype: A research note. Qualitative Research, 16(2), 229–235. https://doi.org/10.1177/1468794115577011   
Sellen, A. (1995). Remote Conversations: The Effects of Mediating Talk With Technology. Human-Computer Interaction, 10(4), 401–444. https://doi.org/10.1207/s15327051hci1004_2   
Shapka, J. D., Domene, J. F., Khan, S., & Yang, L. M. (2016). Online versus in-person interviews with adolescents: An exploration of data equivalence. Computers in Human Behavior, 58(May 2016), 361–367. https://doi.org/10.1016/j. chb.2016.01.016   
Sipes, J. B. A., Roberts, L. D., & Mullan, B. (2019). Voice-only Skype for use in researching sensitive topics: A research note. Qualitative Research in Psychology, 1–17. https://doi.org/10.1080/14780887.2019.1577518   
Sullivan, J. R. (2012). Skype: An Appropriate Method of Data Collection for Qualitative Interviews. The Hilltop Review, 6(1), 54–60. https://scholarworks.wmich.edu/hilltopreview/vol6/iss1/10   
Weinmann, T., Thomas, S., Brilmayer, S., Heinrich, S., & Radon, K. (2012). Testing Skype as an interview method in epidemiologic research: Response and feasibility. International Journal of Public Health, 57(6), 959–961. https:// doi.org/10.1007/s00038-012-0404-7   
Weller, S. (2017). Using internet video calls in qualitative (longitudinal) interviews: Some implications for rapport. International Journal of Social Research Methodology, 20(6), 613–625. https://doi.org/10.1080/13645579.2016. 1269505   
Woodyatt, C. R., Finneran, C. A., & Stephenson, R. (2016). In-Person Versus Online Focus Group Discussions: A Comparative Analysis of Data Quality. Qualitative Health Research, 26(6), 741–749. https://doi.org/10.1177/ 1049732316631510